close all
clc
clear all
%%
addpath('ECGDataDenoised')

Diagnostics = importfile("Diagnostics.xlsx", "Sheet1", [2, 10647]);
filenames = Diagnostics.FileName;
labels = Diagnostics.Rhythm;
S1 = string(labels);
combined_labels = combine_my_labels(S1);
categorical_labels = categorical(combined_labels);
n = grp2idx(categorical_labels);
whole_data = {};
leads = [1,2,3,8];
for i = 1:length(filenames)
    data = import_ecg(strcat('ECGDataDenoised\',filenames(i)), [1, Inf]);
    current_data = table2array(data);
    current_data = current_data(:,leads);
    resampled_data = normalize(resample(current_data,1,5),'zscore'); 
    whole_data{i,1} = resampled_data;
    whole_data{i,2} = n(i);
end  

printf('exit')































function Diagnostics = importfile(workbookFile, sheetName, dataLines)
%IMPORTFILE Import data from a spreadsheet
%  DIAGNOSTICS = IMPORTFILE(FILE) reads data from the first worksheet in
%  the Microsoft Excel spreadsheet file named FILE.  Returns the data as
%  a table.
%
%  DIAGNOSTICS = IMPORTFILE(FILE, SHEET) reads from the specified
%  worksheet.
%
%  DIAGNOSTICS = IMPORTFILE(FILE, SHEET, DATALINES) reads from the
%  specified worksheet for the specified row interval(s). Specify
%  DATALINES as a positive scalar integer or a N-by-2 array of positive
%  scalar integers for dis-contiguous row intervals.
%
%  Example:
%  Diagnostics = importfile("C:\Users\bdemirel\Desktop\ETH Matlab\Contrastive_SQA\ECG-Prep\Diagnostics.xlsx", "Sheet1", [2, 10647]);
%
%  See also READTABLE.
%
% Auto-generated by MATLAB on 27-Apr-2023 10:33:10

%% Input handling

% If no sheet is specified, read first sheet
if nargin == 1 || isempty(sheetName)
    sheetName = 1;
end

% If row start and end points are not specified, define defaults
if nargin <= 2
    dataLines = [2, 10647];
end

%% Set up the Import Options and import the data
opts = spreadsheetImportOptions("NumVariables", 16);

% Specify sheet and range
opts.Sheet = sheetName;
opts.DataRange = "A" + dataLines(1, 1) + ":P" + dataLines(1, 2);

% Specify column names and types
opts.VariableNames = ["FileName", "Rhythm", "Beat", "PatientAge", "Gender", "VentricularRate", "AtrialRate", "QRSDuration", "QTInterval", "QTCorrected", "RAxis", "TAxis", "QRSCount", "QOnset", "QOffset", "TOffset"];
opts.VariableTypes = ["string", "categorical", "categorical", "string", "categorical", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double"];

% Specify variable properties
opts = setvaropts(opts, ["FileName", "PatientAge"], "WhitespaceRule", "preserve");
opts = setvaropts(opts, ["FileName", "Rhythm", "Beat", "PatientAge", "Gender"], "EmptyFieldRule", "auto");

% Import the data
Diagnostics = readtable(workbookFile, opts, "UseExcel", false);

for idx = 2:size(dataLines, 1)
    opts.DataRange = "A" + dataLines(idx, 1) + ":P" + dataLines(idx, 2);
    tb = readtable(workbookFile, opts, "UseExcel", false);
    Diagnostics = [Diagnostics; tb]; %#ok<AGROW>
end
end

function data_to_return = import_ecg(filename, dataLines)
%IMPORTFILE Import data from a text file
%  MUSE2018011115511519000 = IMPORTFILE(FILENAME) reads data from text
%  file FILENAME for the default selection.  Returns the data as a table.
%
%  MUSE2018011115511519000 = IMPORTFILE(FILE, DATALINES) reads data for
%  the specified row interval(s) of text file FILENAME. Specify
%  DATALINES as a positive scalar integer or a N-by-2 array of positive
%  scalar integers for dis-contiguous row intervals.
%
%  Example:
%  MUSE2018011115511519000 = importfile("C:\Users\bdemirel\Desktop\ETH Matlab\Contrastive_SQA\ECG-Prep\ECGDataDenoised\MUSE_20180111_155115_19000.csv", [1, Inf]);
%
%  See also READTABLE.
%
% Auto-generated by MATLAB on 27-Apr-2023 10:37:33

%% Input handling

% If dataLines is not specified, define defaults
if nargin < 2
    dataLines = [1, Inf];
end

%% Set up the Import Options and import the data
opts = delimitedTextImportOptions("NumVariables", 12);

% Specify range and delimiter
opts.DataLines = dataLines;
opts.Delimiter = ",";

% Specify column names and types
opts.VariableNames = ["VarName1", "VarName2", "VarName3", "VarName4", "VarName5", "VarName6", "VarName7", "VarName8", "VarName9", "VarName10", "VarName11", "VarName12"];
opts.VariableTypes = ["double", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double", "double"];

% Specify file level properties
opts.ExtraColumnsRule = "ignore";
opts.EmptyLineRule = "read";

% Import the data
data_to_return = readtable(filename, opts);

end

function combined_labels = combine_my_labels(labels)

combined_labels = labels;
    for k = 1:length(labels)
        if labels(k) == "AF"
            combined_labels(k) = "AFIB";
        elseif labels(k) == "SVT" || labels(k) == "AT" || labels(k) == "SAAWR" || labels(k) == "ST" || labels(k) == "AVNRT" || labels(k) == "AVRT" || labels(k) == "SA"
            combined_labels(k) = "GSVT";
        elseif labels(k) == "SR" || labels(k) == "SI"
            combined_labels(k) = 'SR';
        end
    end
end